#include <stdafx.h>
#include "application.h"

#include <math.h>
#include <algorithm>
#include <fstream>

MoniApplication::ObjectState::ObjectState()
: m_ViewIndex(0), m_ShotAngle(0.0)
{
	m_Stats = Statistics::GetStatistics();
	m_Asteroids.reserve(MAX_ASTEROIDS);
	m_Shots.reserve(MAX_SHOTS);
	m_Ufo = 0;
}

void MoniApplication::RunPrediction(double shotAngle) {
	MyAutoLockCS al(m_DataLock);

    m_RealObjectState.m_DeadlyObjects.clear();
    m_RealObjectState.m_NextObjects.clear();

    unsigned long numAstros = m_RealObjectState.m_Asteroids.size();
	for(unsigned long i = 0; i < numAstros; ++i) {
		MyAsteroid &a = m_RealObjectState.m_Asteroids[i];
 		bool okay = a.EstimateRealHitTime( m_RealObjectState.m_ShotAngle );
		if( okay ) {
            double crit = (a.m_Time2Turn + a.m_Time2Wait + a.m_Time2Hit);
			if(a.m_DeadlyObject) {
				m_RealObjectState.m_DeadlyObjects[a.m_Time2Impact] = i;
			}
            else if(a.m_ID == m_NextTargetID) {
                m_RealObjectState.m_NextObjects[0.9 * crit ] = i;
            }
            else {
                m_RealObjectState.m_NextObjects[crit] = i;
            }
		}
	}
}


void MoniApplication::ObjectState::UpdateCurrentObjectState(GameStatus &currentState, long currentFrameCnt, unsigned int lastShotID4Correction, long nextUpdateAllowed, wchar_t info[256]) {
	m_TimeStamp = currentFrameCnt;

	if(NOW) {
		NOW = false;
	}

	Statistics::LevelData *levelData = NULL;
	if(m_Stats->m_GameRunning) {
		// first level started?
		if( (m_Stats->m_CurrentLevel == -1) && (currentState.m_nasteroids != 0) && m_Asteroids.empty() ) {
			m_Stats->m_CurrentLevel = 0;
			m_Stats->m_Levels.resize( 1 );
			levelData = &m_Stats->m_Levels.back();

			wchar_t info[512];
			swprintf_s(info, 32, L"Level %ld started!", m_Stats->m_CurrentLevel+1);
			moni.UpdateInfo(info);
		}
		// no: level finished?
		else if( (currentState.m_nasteroids == 0) && (m_Asteroids.size() != m_Ufo) ) {
			Statistics::LevelData &data = m_Stats->m_Levels.back();
			// calc level data
			data.m_Points = m_Stats->m_Score;

			// start new level
			m_Stats->m_CurrentLevel += 1;
			m_Stats->m_Levels.resize( m_Stats->m_CurrentLevel + 1 );
			levelData = &m_Stats->m_Levels.back();

			wchar_t info[512];
			swprintf_s(info, 32, L"Level %ld cleared!", m_Stats->m_CurrentLevel);
			moni.UpdateInfo(info);
		}
		// level running?
		if( m_Stats->m_CurrentLevel >= 0 ) {
			levelData = &m_Stats->m_Levels.back();
			levelData->m_Frames += 1;
		}
	}

	//***************************************//
	// ME
	//***************************************//
	if (currentState.m_ship_present) {
		double diffPosX = currentState.m_ship_x - m_ShipCentre.m_x;
		double diffPosY = currentState.m_ship_y - m_ShipCentre.m_y;
		if( (diffPosX != 0) || (diffPosY != 0) ) {
			for(unsigned long k = 0; k < m_Shots.size(); ++k) {
                MyShot &s = m_Shots[k];
				s.m_Centre.m_x = NormalizeX(s.m_Centre.m_x + diffPosX);
				s.m_Centre.m_y = NormalizeY(s.m_Centre.m_y + diffPosY);
				s.m_LastCentre.m_x = NormalizeX(s.m_LastCentre.m_x + diffPosX);
				s.m_LastCentre.m_y = NormalizeY(s.m_LastCentre.m_y + diffPosY);
			}
			for(unsigned long k = 0; k < m_Asteroids.size(); ++k) {
				MyAsteroid &a = m_Asteroids[k];
				a.m_Centre.m_x = NormalizeX(a.m_Centre.m_x + diffPosX);
				a.m_Centre.m_y = NormalizeY(a.m_Centre.m_y + diffPosY);
				a.m_LastCentre.m_x = NormalizeX(a.m_LastCentre.m_x + diffPosX);
				a.m_LastCentre.m_y = NormalizeY(a.m_LastCentre.m_y + diffPosY);
			}
		}
		m_ShipPresent = true;
		m_ShipCentre.m_x = currentState.m_ship_x;
		m_ShipCentre.m_y = currentState.m_ship_y;
		m_ShipViewX = currentState.m_ship_dx;
		m_ShipViewY = currentState.m_ship_dy;
	}
	else {
		// adjust all positions of astros and shots
		double diffPosX = 524 - m_ShipCentre.m_x;
		double diffPosY = 396 - m_ShipCentre.m_y;
		if( (diffPosX != 0) || (diffPosY != 0) ) {
			for(unsigned long k = 0; k < m_Shots.size(); ++k) {
                MyShot &s = m_Shots[k];
				s.m_Centre.m_x = NormalizeX(s.m_Centre.m_x + diffPosX);
				s.m_Centre.m_y = NormalizeY(s.m_Centre.m_y + diffPosY);
				s.m_LastCentre.m_x = NormalizeX(s.m_LastCentre.m_x + diffPosX);
				s.m_LastCentre.m_y = NormalizeY(s.m_LastCentre.m_y + diffPosY);
			}
			for(unsigned long k = 0; k < m_Asteroids.size(); ++k) {
				MyAsteroid &a = m_Asteroids[k];
				a.m_Centre.m_x = NormalizeX(a.m_Centre.m_x + diffPosX);
				a.m_Centre.m_y = NormalizeY(a.m_Centre.m_y + diffPosY);
				a.m_LastCentre.m_x = NormalizeX(a.m_LastCentre.m_x + diffPosX);
				a.m_LastCentre.m_y = NormalizeY(a.m_LastCentre.m_y + diffPosY);
			}
		}
		// update anyway so we can calc stuff
		m_ShipPresent = false;
		m_ShipCentre.m_x = 524;
		m_ShipCentre.m_y = 396;
	}

	if(m_ShipPresent) {
		MyAutoLockCS al(m_Stats->m_DataLock);

		// view of current frame was created by 2nd last command
		m_ViewIndex = m_ViewIndex + m_Stats->m_LastMoves[1].m_Move;
		if(m_ViewIndex < 0) m_ViewIndex += 256;
		if(m_ViewIndex > 255) m_ViewIndex -= 256;
		long estViewAngle = m_Stats->m_AngleLUT[m_ViewIndex].first;

		// calc and store current view angle
		long viewAngle = (long)(180.0 * atan2((double)currentState.m_ship_dy, (double)currentState.m_ship_dx) / M_PI);
		if(viewAngle < 0.0) viewAngle += 360;
		m_Stats->m_LastViewAngles.push_front(viewAngle);
		while(m_Stats->m_LastViewAngles.size() > 100) m_Stats->m_LastViewAngles.pop_back();

		wchar_t info[512] = L"";
		// check if it matches view angle
		if(viewAngle != estViewAngle) {
			long i = 1, index;
			for(; i < 128; ++i) {
				index = m_ViewIndex + i;
				if(index > 255) index -= 256;
				if( m_Stats->m_AngleLUT[index].first == viewAngle) {
					m_ViewIndex = index;
					break;
				}
				index = m_ViewIndex - i;
				if(index < 0) index += 256;
				if( m_Stats->m_AngleLUT[index].first == viewAngle) {
					m_ViewIndex = index;
					break;
				}
			}
			if(i == 128) {
				swprintf_s(info, 32, L"%ld != %ld WRONG", viewAngle, estViewAngle);
			}
			else {
				swprintf_s(info, 32, L"%ld != %ld CORRECTED", viewAngle, estViewAngle);
			}
		}

		if(info[0] != 0) {
			moni.UpdateInfo(info);
		}

        long angleIdx = m_ViewIndex + m_Stats->m_LastMoves[0].m_Move + m_Stats->m_MissingMoves;
	    while(angleIdx > 255) angleIdx -= 256;
	    while(angleIdx < 0) angleIdx += 256;
		m_ShotAngle = m_Stats->m_AngleLUT[angleIdx].second;

		// store corrected view index
		m_Stats->m_ViewIndexHisto.push_front( (BYTE)m_ViewIndex );
		while(m_Stats->m_ViewIndexHisto.size() > 100) m_Stats->m_ViewIndexHisto.pop_back();
	}

	int ship_x = (int)m_ShipCentre.m_x;
	int ship_y = (int)m_ShipCentre.m_y;


	//***************************************//
	// ASTEROIDS
	//***************************************//
    long numFFHitting = 0;
	// all objects "untouched" first
	for(unsigned long k = 0; k < m_Asteroids.size(); ++k) {
		m_Asteroids[k].Touch(false);
	}
	// update internal astro list
	unsigned long k = 0;
    double dx, dy, dist;
    int i;
	for (i = 0; i < currentState.m_nasteroids; ++i) {
        Asteroid &ba = currentState.m_asteroids[i];
		ba.m_x = NormalizeX(ba.m_x - ship_x);
		ba.m_y = NormalizeY(ba.m_y - ship_y);

		for(k = 0; k < m_Asteroids.size(); ++k) {
			if(m_Asteroids[k].UpdateMatchingObject(currentFrameCnt, ASTERIOD_ANY, ba.m_x, ba.m_y, ba.m_sf, ba.m_type)) {
                MyAsteroid &a = m_Asteroids[k];
				// found match: calc stuff
				a.CalcDynamicData(m_ShotAngle);
	            for( unsigned long i = 0; i < m_Shots.size(); ++i) {
                    MyShot &s = m_Shots[i];
                    // check only with my target
                    if( (s.m_ShouldHit != 0) || (a.m_ID != s.m_TargetID) ) continue;
                    dx = s.m_Centre.m_x - a.m_Centre.m_x;
                    dy = s.m_Centre.m_y - a.m_Centre.m_y;
                    dist = sqrt(dx*dx + dy*dy);
                    if( dist < a.m_Size ) {
		                if(levelData != NULL) {
                            levelData->m_Check_NumFFSuccess += 1;
                        }
                        s.m_ShouldHit = 1;
                        numFFHitting += 1;
                    }
                }
				break;
			}
		}
		// new astro
		if(k == m_Asteroids.size()) {
			m_Asteroids.push_back( MyAsteroid(currentFrameCnt, currentState.m_asteroids[i]) );
			if(levelData != NULL) {
				levelData->m_NumAstros[m_Asteroids.back().m_Typ] += 1;
			}
		}
	}

	//***************************************//
	// UFO
	//***************************************//
	if (currentState.m_saucer_present) {
		m_Ufo = 1;
		currentState.m_saucer_x = NormalizeX(currentState.m_saucer_x - ship_x);
		currentState.m_saucer_y = NormalizeY(currentState.m_saucer_y - ship_y);
		for( k = 0; k < m_Asteroids.size(); ++k) {
            MyAsteroid &a = m_Asteroids[k];
			if(a.UpdateMatchingObject(currentFrameCnt, UFO, currentState.m_saucer_x, currentState.m_saucer_y, currentState.m_saucer_size, 5)) {
				// found match: finito
				a.CalcDynamicData(m_ShotAngle);
                // check if some shot hits!
                for( unsigned long j = 0; j < m_Shots.size(); ++j) {
                    MyShot &s = m_Shots[j];
                    // check only with my target
                    if( (s.m_ShouldHit != 0) || (a.m_ID != s.m_TargetID) ) continue;
                    dx = s.m_Centre.m_x - a.m_Centre.m_x;
                    dy = s.m_Centre.m_y - a.m_Centre.m_y;
                    dist = sqrt(dx*dx + dy*dy);
                    if( dist < a.m_Size ) {
	                    if(levelData != NULL) {
                            levelData->m_Check_NumFFSuccess += 1;
                        }
                        s.m_ShouldHit = 1;
                        numFFHitting += 1;
                    }
                }
				break;
			}
		}
		// new UFO
		if(k == m_Asteroids.size()) {
			m_Asteroids.push_back( MyAsteroid(currentFrameCnt, currentState.m_saucer_x, currentState.m_saucer_y, currentState.m_saucer_size) );
			if(levelData != NULL) {
				levelData->m_NumUFO += 1;
			}
		}
	}
	else {
		m_Ufo = 0;
	}

    unsigned int lastTargetIndex = -1;
	// remove not existing astros!
	for(k = 0; k < m_Asteroids.size(); ) {
		if(!m_Asteroids[k].m_Touched) {
			m_Asteroids.erase(m_Asteroids.begin() + k);
		}
		else {
			if(m_Asteroids[k].m_ID == m_Stats->m_LastTargets[1].first) {
				lastTargetIndex = k;
			}
			++k;
		}
	}


	//***************************************//
	// SHOTS
	//***************************************//

	// all shots "untouched" first
	for(k = 0; k < m_Shots.size(); ++k) {
		m_Shots[k].Touch(false);
	}

	// update internal shot list
	bool newFriendlyShot = false;
	long numFriendlyFire = 0;
	for(i = 0; i < currentState.m_nshots; ++i) {
		currentState.m_shots[i].m_x = NormalizeX(currentState.m_shots[i].m_x - ship_x);
		currentState.m_shots[i].m_y = NormalizeY(currentState.m_shots[i].m_y - ship_y);

		for( k = 0; k < m_Shots.size(); ++k) {
			MyShot &s = m_Shots[k];
			if(s.UpdateMatchingObject(currentFrameCnt, SHOT_ANY, currentState.m_shots[i].m_x, currentState.m_shots[i].m_y, 0, 0)) {
				// found match
				s.CalcDynamicData(m_ShotAngle);
				// check shot angle
				if( m_ShipPresent && (nextUpdateAllowed <= 0) && (s.m_Typ == FF) && (s.m_ID != lastShotID4Correction) && (s.m_DCount == 17) ) {
					lastShotID4Correction = s.m_ID;
					// angle of shot
					double lastShotAngle = CalcAngle(s.m_Speed);
					// predicted angle
					double wb_angle = m_Stats->m_AngleLUT[s.m_ShotAngleIndex].second;
					while(wb_angle > 360.0) wb_angle -= 360.0;
					while(wb_angle < 0.0) wb_angle += 360.0;

					if(fabs(wb_angle - lastShotAngle) > 180.0) {
						if(wb_angle > lastShotAngle) {
							wb_angle -= 360.0;
						}
						else {
							wb_angle += 360.0;
						}
					}
					// if real shot angle doesnt match predicted: correct it
					if(fabs(wb_angle - lastShotAngle) > 1.0) {
						swprintf(info, 256, L"BAD SHOT %ld: %.2lf -> %.2lf!", s.m_ID, lastShotAngle, wb_angle);
					}
				}
				break;
			}
		}
		// new shot
		if(k == m_Shots.size()) {
			MyAutoLockCS al(m_Stats->m_DataLock);
			m_Shots.push_back( MyShot(currentFrameCnt, currentState.m_shots[i], m_Stats->m_ViewIndexHisto[1]) );
			MyShot &o = m_Shots.back();
			if(o.m_Typ == FF) {
                // set time 2 live & other stuff
				newFriendlyShot = true;
				MyAutoLockCS al(m_Stats->m_DataLock);
				o.m_TargetID = m_Stats->m_LastTargets[1].first;
                o.m_Time2Live = m_Stats->m_LastTargets[1].second;
                if(o.m_TargetID != -1) {
		            for( k = 0; k < m_Asteroids.size(); ++k) {
                        if(m_Asteroids[k].m_ID == o.m_TargetID) {
                            o.m_Size = m_Asteroids[k].m_Size;
                            break;
                        }
                    }
                }
			}
		}
	}
	// remove not existing shots!
	for(k = 0; k < m_Shots.size(); ) {
        MyShot &s = m_Shots[k];
		if(!s.m_Touched) {
			m_Shots.erase(m_Shots.begin() + k);
		}
		else {
            if(s.m_Typ == FF) {
                numFriendlyFire += 1;
            }
            if(s.m_ShouldHit != 0) {
                s.m_ShouldHit += 1; // increase since it should have hit already!
            }
			++k;
		}
	}

    if( (m_NumFriendlyFire == 4) && (levelData != NULL) ){
        levelData->m_Check_NumFFCount += 1;
    }
    m_NumFriendlyFire = numFriendlyFire - numFFHitting;

	// could not shot this predicted target
	if( !newFriendlyShot && (lastTargetIndex != -1) ) {
		m_Asteroids[ lastTargetIndex ].m_EstimatedBlowTime = 0;
		m_Asteroids[ lastTargetIndex ].m_Shots = 0;
	}

	--nextUpdateAllowed;
}

